<?php
// MINI CLASS HANDLING THE wp_mail() ERROR RETRIEVAL

class pcma_wp_mail_errors {
    
    private static $action_enqueued = false; // (bool) static resource to avoid using the same action multiple times
    
    public $wp_error_txt = false; // (false|string) the email sending error retrieved
    private $global_name = 'pcma_wp_mail_error'; // (string) global variable name
    
    
    
    /* maybe add action to intercept $wp_error messages and delete previous errors */
    public function __construct() {
        if(!self::$action_enqueued) {
            add_action('wp_mail_failed', array($this, 'wp_mail_failed_action'), 100, 1);
            self::$action_enqueued = true;
        }
        
        if(isset($GLOBALS[ $this->global_name ])) {
            unset($GLOBALS[ $this->global_name ]);    
        }
    }
    
    
    
    
    
    /* intercept $wp_error messages  and store it in $this->wp_error_txt */
    public function wp_mail_failed_action($wp_error) {
        if(is_object($wp_error) && !empty($wp_error->get_error_message())) {
            $this->wp_error_txt = $wp_error->get_error_message();
        }
        else {
            $this->wp_error_txt = false;    
        }
    }
    

    
    
    
    /* returns the error and also sets it in $GLOBALS['pcma_wp_mail_error'] */
    public function get_error() {
        global $phpmailer;
        $to_return = 'unknown reason';
        
        if($this->wp_error_txt) {
            $to_return = $this->wp_error_txt;     
        }
        elseif(isset($phpmailer)) {
            $to_return = $phpmailer->ErrorInfo;
        }
        
        $GLOBALS[ $this->global_name ] = $to_return;
        return $to_return;    
    }
    
}